/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.ui;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.resources.UniformResourceStorage;
import com.aptana.core.util.EclipseUtil;
import com.aptana.js.debug.core.internal.browsers.FirebugUtil;
import com.aptana.js.debug.core.model.IJSDebugTarget;
import com.aptana.js.debug.ui.CommonMessages;
import com.aptana.js.debug.ui.internal.DebugUIImages;
import com.aptana.js.debug.ui.internal.LaunchConfigurationsHelper;
import com.aptana.ui.util.UIUtils;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.WorkbenchJob;
import org.osgi.framework.BundleContext;

public class JSDebugUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.aptana.js.debug.ui";
    private static JSDebugUIPlugin plugin;
    private IDebugModelPresentation fUtilPresentation;
    private IDebugEventSetListener debugEventListener;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        if (this.debugEventListener == null) {
            this.debugEventListener = new IDebugEventSetListener(){

                public void handleDebugEvents(DebugEvent[] events) {
                    DebugEvent[] debugEventArray = events;
                    int n = events.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DebugEvent event = debugEventArray[n2];
                        if (event.getSource() instanceof IJSDebugTarget && event.getKind() == 8) {
                            WorkbenchJob job = new WorkbenchJob("Close Temporary Debug Editors"){

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    JSDebugUIPlugin.this.closeDebugEditors();
                                    return Status.OK_STATUS;
                                }
                            };
                            job.setPriority(10);
                            EclipseUtil.setSystemForJob((Job)job);
                            job.schedule();
                        }
                        ++n2;
                    }
                }
            };
        }
        DebugPlugin.getDefault().addDebugEventListener(this.debugEventListener);
        this.registerAsFirebugEditor();
        LaunchConfigurationsHelper.doCheckDefaultLaunchConfigurations();
    }

    public void stop(BundleContext context) throws Exception {
        DebugPlugin.getDefault().removeDebugEventListener(this.debugEventListener);
        plugin = null;
        super.stop(context);
    }

    public static JSDebugUIPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    protected ImageRegistry createImageRegistry() {
        return DebugUIImages.getImageRegistry();
    }

    public IDebugModelPresentation getModelPresentation() {
        if (this.fUtilPresentation == null) {
            this.fUtilPresentation = DebugUITools.newDebugModelPresentation((String)"com.aptana.js.debug.core");
        }
        return this.fUtilPresentation;
    }

    private void registerAsFirebugEditor() {
        IPath launcher = EclipseUtil.getApplicationLauncher();
        if (launcher != null) {
            FirebugUtil.registerEditor((String)CommonMessages.ProductShortName, (String)CommonMessages.ProductName, (IPath)launcher, (String)"");
        }
    }

    private void closeDebugEditors() {
        IWorkbenchPage page = UIUtils.getActivePage();
        if (page != null) {
            IEditorReference[] editorRefs = page.getEditorReferences();
            ArrayList<IEditorReference> closeEditors = new ArrayList<IEditorReference>();
            IEditorReference[] iEditorReferenceArray = editorRefs;
            int n = editorRefs.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference ref = iEditorReferenceArray[n2];
                try {
                    URI uri;
                    IEditorInput input = ref.getEditorInput();
                    UniformResourceStorage storage = (UniformResourceStorage)input.getAdapter(UniformResourceStorage.class);
                    if (storage != null && "dbgsource".equals((uri = storage.getURI()).getScheme())) {
                        closeEditors.add(ref);
                    }
                }
                catch (PartInitException e) {
                    IdeLog.logError((Plugin)JSDebugUIPlugin.getDefault(), (Throwable)e);
                }
                ++n2;
            }
            if (!closeEditors.isEmpty()) {
                page.closeEditors(closeEditors.toArray(new IEditorReference[closeEditors.size()]), false);
            }
        }
    }
}

